<?php

namespace App\Form;

use App\Entity\BookingTable;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\Regex;

class BookingTableType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('dataPrenotazione')
            ->add('oraPrenotazione')
            ->add('numeroPersone', ChoiceType::class, [
                'choices' => array_combine(range(0, 10), range(0, 10)),
                'label' => 'Numero di persone',
            ])
            ->add('nomeCognome')
            ->add('email', EmailType::class, [
                'label' => 'Email',
            ])
            ->add('phone', TextType::class, [
                'label' => 'Numero di telefono',
                'constraints' => [
                    new NotBlank(),
                    new Regex([
                        'pattern' => '/^[0-9]+$/',
                        'message' => 'Il numero di telefono deve contenere solo cifre.',
                    ]),
                ],
            ])
            ->add('notePrenotazione', TextareaType::class, [
                'label' => 'Note aggiuntive',
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => BookingTable::class,
        ]);
    }
}