<?php

namespace App\Entity;

use App\Repository\BookingTableRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: BookingTableRepository::class)]
class BookingTable
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(type: Types::DATE_MUTABLE)]
    private ?\DateTime $dataPrenotazione = null;

    #[ORM\Column(type: Types::TIME_MUTABLE)]
    private ?\DateTime $oraPrenotazione = null;

    #[ORM\Column]
    private ?int $numeroPersone = null;

    #[ORM\Column(length: 255)]
    private ?string $nomeCognome = null;

    #[ORM\Column(length: 255)]
    private ?string $email = null;

    #[ORM\Column(length: 255)]
    private ?string $phone = null;

    #[ORM\Column(length: 2000, nullable: true)]
    private ?string $notePrenotazione = null;

    #[ORM\Column]
    private ?bool $confermato = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getDataPrenotazione(): ?\DateTime
    {
        return $this->dataPrenotazione;
    }

    public function setDataPrenotazione(\DateTime $dataPrenotazione): static
    {
        $this->dataPrenotazione = $dataPrenotazione;

        return $this;
    }

    public function getOraPrenotazione(): ?\DateTime
    {
        return $this->oraPrenotazione;
    }

    public function setOraPrenotazione(\DateTime $oraPrenotazione): static
    {
        $this->oraPrenotazione = $oraPrenotazione;

        return $this;
    }

    public function getNumeroPersone(): ?int
    {
        return $this->numeroPersone;
    }

    public function setNumeroPersone(int $numeroPersone): static
    {
        $this->numeroPersone = $numeroPersone;

        return $this;
    }

    public function getNomeCognome(): ?string
    {
        return $this->nomeCognome;
    }

    public function setNomeCognome(string $nomeCognome): static
    {
        $this->nomeCognome = $nomeCognome;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(string $email): static
    {
        $this->email = $email;

        return $this;
    }

    public function getPhone(): ?string
    {
        return $this->phone;
    }

    public function setPhone(string $phone): static
    {
        $this->phone = $phone;

        return $this;
    }

    public function getNotePrenotazione(): ?string
    {
        return $this->notePrenotazione;
    }

    public function setNotePrenotazione(?string $notePrenotazione): static
    {
        $this->notePrenotazione = $notePrenotazione;

        return $this;
    }

    public function isConfermato(): ?bool
    {
        return $this->confermato;
    }

    public function setConfermato(bool $confermato): static
    {
        $this->confermato = $confermato;

        return $this;
    }
}
